(ns
    #^{:author "renarl",
       :doc "gets custom render spec from tda"}
  lv.lumii.tda.export.custom-render-spec
  (:use lv.lumii.tda
        lv.lumii.tda.utilities
        lv.lumii.tda.export.utilities
				lv.lumii.tda.send)
  (:import [org.semanticweb.owlapi.model OWLClass OWLIndividual OWLDataProperty OWLObjectProperty OWLLiteral IRI]
			(java.io File BufferedWriter FileOutputStream OutputStreamWriter BufferedReader InputStreamReader FileInputStream)
			(org.semanticweb.owlapi.util SimpleIRIMapper)
			(org.coode.owlapi.functionalparser OWLFunctionalSyntaxParser)
			(org.semanticweb.owlapi.model AddAxiom OWLOntologyID IRI AddImport OWLOntologyLoaderConfiguration)))

(defn get-custom-ontology-from-tda [ip timeout port]
	(let [tmp-file (. File createTempFile "tmp-ontology" ".owl")
				physical-uri (.toURI tmp-file)
				{prefixes "prefixes" axioms "axioms"} (with-in-str (send-data ip timeout port "get custom render spec" true) (read))
				string-representation (str prefixes "\nOntology(<" (str physical-uri) ">\n" axioms ")")]
		(.deleteOnExit tmp-file)
		string-representation))

(defn load-custom-render-pref-ontology [prefixes axioms]
  (let [tmp-file (. File createTempFile "tmp-custom-render-pref-ontology" ".owl")
				physical-uri (.toURI tmp-file)
				string-representation (str prefixes "\nOntology(<" (str physical-uri) ">\n" axioms ")")
				iri (IRI/create physical-uri)
        out (new OutputStreamWriter (new FileOutputStream tmp-file) "UTF8")]
    (do
      (.deleteOnExit tmp-file)
      (.write out string-representation)
      (.close out)
      (let [ontology 
            (let [current-ontology (first (filter #(= iri (.getOntologyIRI (.getOntologyID %1))) (.getOntologies OWLOntologyManager)))]
						  (if current-ontology
  					    (do
  					      (.applyChanges OWLOntologyManager (.removeAxioms OWLOntologyManager
  					                                        current-ontology
  					                                        (.getAxioms current-ontology)))
  					      current-ontology)
						    (do
  						    (.. OWLOntologyManager (addIRIMapper (new SimpleIRIMapper iri (IRI/create tmp-file))))
  						    (.. OWLOntologyManager (createOntology iri)))))]
				; šis pagaidām aizkomentēts jo nav skaidrs kas ir analogs iekš owlapi
        #_(.setPhysicalURI OWLModelManager ontology physical-uri)
        (let [parser (doto (new OWLFunctionalSyntaxParser (new FileInputStream tmp-file) "UTF8")
                        (.setUp OWLOntologyManager ontology (new OWLOntologyLoaderConfiguration)))
              format (.parse parser)]
            (.setOntologyFormat OWLOntologyManager ontology format))
        ontology))))