(ns
    #^{:author "renarl",
       :doc "export pipeline"}
  lv.lumii.tda.export.pipeline
  (:use lv.lumii.tda
        lv.lumii.tda.utilities
        lv.lumii.tda.preferences))

(defn export-block-id [export-block]
	(str (:group export-block) " - " (:name export-block)))

(defn block-active?
  "returns wether block should be used"
  [export-block]
  ; (println (str (exporter-enabled? (export-block-id export-block)) "   " (:group export-block) " - " (:name export-block)))
  (exporter-enabled? (export-block-id export-block)))

(defn- get-chunk-exporter
  "selects appropriate chunk exporter if there are more then one"
  [export-block]
  (:exporter export-block))

(defn- merge-changes
  "add that which is is in addition and subtract that which is in deletion"
  [current-hash {:keys [deletions additions] :as changes}]
  (if (or deletions additions)
    (my-merge (my-diff current-hash deletions) additions)
    (my-merge current-hash changes)))

(defn- apply-export-block
  "apply export block to accumulator and ontology, produces revised accumulator with added and removed entries"
  [{:keys [before after chunker] :as export-block} accumulator ontology]
  (if (block-active? export-block)
    (do ;(println (:name export-block))
      ; (println (str "--- doing block" (:name export-block)))
      (let [acc1 (if-not before
                 accumulator
                 (merge-changes accumulator (before accumulator ontology)))
          acc2 (if-not chunker
                 acc1
                 (let [chunks (chunker acc1 ontology)]
                   (if (nil? chunks)
                     acc1
                     (reduce (fn [acc chunk]
                               (merge-changes acc ((get-chunk-exporter export-block) chunk acc ontology)))
                             acc1
                             (if (coll? chunks)
                               chunks
                               #{chunks})))))
          acc3 (if-not after
                 acc2
                 (merge-changes acc2 (after acc2 ontology)))]
      acc3))
    accumulator))

(defn export-with
  "runs supplied ontology through supplied export blocks, produces hash-map with ontology in tda form"
  ([ontology export-blocks canceled? done? progress acc]
     (reduce
      (fn [accumulator export-block]
        (if-not (vector? export-block)
          (do (swap! progress inc)
							(apply-export-block export-block accumulator ontology))
          (export-with ontology export-block canceled? done? progress accumulator)))
      acc
      (take-while (fn [_] 
										(if @canceled? (reset! done? true))
										(not @canceled?))
									export-blocks)))
  ([ontology export-blocks canceled? done? progress]
     (export-with ontology export-blocks canceled? done? progress {}))
	([ontology export-blocks]
     (export-with ontology export-blocks (atom false) (atom false) (atom 0))))

;(export-with 'aoe [{:before (fn [a o] (println "before"))
;                    :after (fn [a o] (println "after"))
;                    :exporter (fn [c a o]
;                                (do (println c)
;                                    {:additions {:a c}}))
;                    :chunker (fn [a o] [1 2 3])}])
