(ns lv.lumii.tda.export.progress-monitor
  (:import
    javax.swing.JButton
    javax.swing.JFrame
		javax.swing.JDialog
    javax.swing.JProgressBar
		javax.swing.SwingUtilities
		java.awt.Frame
    com.jgoodies.forms.layout.CellConstraints
    com.jgoodies.forms.layout.FormLayout
    com.jgoodies.forms.factories.ButtonBarFactory
    com.jgoodies.forms.builder.PanelBuilder)
  (:use
    [clojure.tools.swing-utils
     :only (do-swing do-swing* add-action-listener)]
		lv.lumii.tda))

(defn- make-process-with-progress-monitor-fn
  [data process-fn estimated-number-of-actions finished-data-ref]
		(fn [] 
			(let [frame     (JDialog. (cast java.awt.Dialog nil)
				 												"Visualizing Ontology"
																true)
	          layout    (FormLayout. "fill:default:grow" "pref,3dlu,pref")
	          cc        (CellConstraints.)
  
	          progress  (atom 0)
	          pbar      (JProgressBar. @progress estimated-number-of-actions)
  
	          done?     (atom false)
  
	          canceled? (atom false)
	          cancel    (JButton. "Cancel")
  
	          bbar      (ButtonBarFactory/buildCenteredBar (into-array [cancel]))
  
	          panel     (-> (PanelBuilder. layout)
	                      (doto
	                        (.setDefaultDialogBorder)
	                        (.add pbar (.xy cc 1 1))
	                        (.add bbar (.xy cc 1 3)))
	                      .getPanel)]
	      (add-watch
	        done?
	        ::close-on-done
	        (fn [_ _ _ done?]
	          (do-swing
	            (when done?
	              (doto frame
	  	            (.setVisible false)
	  	            (.dispose))))))
  	
	      ; Wire up cancel button.
	      (add-action-listener
	        cancel
	        (fn [_]
	          (reset! canceled? true)))
  
	      ; Wire up progress bar.
	      (add-watch
	        progress
	        ::update-progress-bar
	        (fn [_ _ _ v]
	          (do-swing
	            (.setValue pbar v))))
  
	      (doto frame
	        (.setDefaultCloseOperation JFrame/DISPOSE_ON_CLOSE)
	        (-> .getContentPane (.add panel))
	        (.pack)
					(.setSize 300 (.height (.getSize frame)))
					(.setResizable false)
					(.setLocationRelativeTo nil)
					(.toFront))
  
	  		(-> #(process-fn data canceled? done? progress finished-data-ref) Thread. .start)
				(doto frame (.setVisible true)))))

(defn process-with-progress-monitor*
	[data process-fn estimated-number-of-actions]
	(let [finished-data-ref (ref {:finished false :data nil})]
		(do-swing* :now 
			(make-process-with-progress-monitor-fn data
			 																		 	 process-fn
																					 	 estimated-number-of-actions
																						 finished-data-ref))
		finished-data-ref))
	