(ns
    #^{:author "renarl",
       :doc "import from tda"}
  lv.lumii.tda.import
  (:use lv.lumii.tda
        lv.lumii.tda.utilities)
  (:import (org.semanticweb.owlapi.apibinding OWLManager)
           (java.net URI)
           (java.io File FileOutputStream OutputStreamWriter FileInputStream)
					 (org.semanticweb.owlapi.model AddAxiom OWLOntologyID IRI AddImport OWLOntologyLoaderConfiguration)
					 (org.semanticweb.owlapi.util SimpleIRIMapper)
					 (org.coode.owlapi.functionalparser OWLFunctionalSyntaxParser)
					 (org.semanticweb.owlapi.io FileDocumentSource)))

(defn- loaded-ontology-by-iri [iri]
	(first (filter #(= iri (.getOntologyIRI (.getOntologyID %1))) (.getOntologies OWLOntologyManager))))

(defn load-ontology [string-representation iri]
  (let [tmp-file (new File "C:\\Users\\renarl\\Desktop\\aoe-test.owl")
        physical-uri (.toURI tmp-file)
        out (new OutputStreamWriter (new FileOutputStream tmp-file) "UTF8")]
    (do
      (.write out string-representation)
      (.close out)
      (let [ontology 
            (let [current-ontology (loaded-ontology-by-iri iri)]
						  (if current-ontology
  					    (do
  					      (.applyChanges OWLOntologyManager (.removeAxioms OWLOntologyManager
  					                                        current-ontology
  					                                        (.getAxioms current-ontology)))
  					      current-ontology)
						    (do
  						    (.. OWLOntologyManager (addIRIMapper (new SimpleIRIMapper iri (IRI/create tmp-file))))
  						    (.. OWLOntologyManager (createOntology iri)))))]
				;pagaidām aizkomentējam, nav skaidrs kādēļ vajadzīgs
        #_(.setPhysicalURI OWLModelManager ontology physical-uri)
        (let [parser (doto (new OWLFunctionalSyntaxParser (new FileInputStream tmp-file) "UTF8")
                        (.setUp OWLOntologyManager ontology (new OWLOntologyLoaderConfiguration)))
              format (.parse parser)]
            (.setOntologyFormat OWLOntologyManager ontology format))
        ontology))))

(defn- add-ontology-imports [ontology import-iri-col]
  (let [factory (.getOWLDataFactory OWLOntologyManager)
        changes (map (fn [import-iri]
					              (AddImport. ontology
					                          (.getOWLImportsDeclaration factory
					                                                     import-iri)))
				             import-iri-col)]
		(if-not (empty? changes)
			(.applyChanges OWLOntologyManager changes))))

(defn- load-ontology-from-table [table]
  (println "\n--- " (get table "ontology_uri"))
  (let [ontology-iri (IRI/create (get table "ontology_uri"))
	      ontology (load-ontology (get table "ontology") ontology-iri)
	      ontology-iri-col (map #(IRI/create %) (get table "ontology_import_iris" #{}))]
    (do
			(add-ontology-imports ontology ontology-iri-col)
			(println (get table "ontology_uri") " import finished"))))

(defn embeded-import-from-tda [table]
	(println "---table" table)
	(doseq [t table] (load-ontology-from-table t)))
