(ns
    #^{:author "renarl",
       :doc "ontology logical diff"}
  lv.lumii.tda.ontology-diff
  (:use lv.lumii.tda
        lv.lumii.tda.export
        lv.lumii.tda.export.utilities
        lv.lumii.tda.utilities
        lv.lumii.tda.serialize)
  (:import (org.semanticweb.owlapi.apibinding OWLManager)
           (java.net URI)
           (java.io File FileOutputStream OutputStreamWriter FileInputStream)
           (org.semanticweb.owlapi.model AddAxiom OWLOntologyID IRI AddImport OWLOntologyLoaderConfiguration)
           (org.semanticweb.owlapi.util SimpleIRIMapper)
           (org.coode.owlapi.functionalparser OWLFunctionalSyntaxParser)
           (org.semanticweb.owlapi.io FileDocumentSource)
           (org.semanticweb.owlapi.reasoner.structural StructuralReasonerFactory)
           (org.semanticweb.HermiT Configuration Reasoner$ReasonerFactory)))


(defn- diff [current-ontology new-ontology]
  ; (println "-----------------")
  ; (println "current" current-ontology)
  ; (println "new" new-ontology)
  (reduce (fn [acc {:keys [axiom entailment-supported entailed contained] :as v}]
            ; (println v)
            ; (if (and (= entailment-supported false) (= contained false)) (println "!!!!" (render axiom)))
            (if (and (= entailed false) (= contained false))
              (conj acc axiom)
              acc))
           []
           (let [reasoner-configuration (doto (Configuration.) (#(set! (. % throwInconsistentOntologyException) false)))
                 reasoner (doto (.createReasoner (Reasoner$ReasonerFactory.)
                                                 current-ontology
                                                 reasoner-configuration))
                 diffs (map (fn [axiom]
                                        {:axiom axiom ;(render axiom)
                                         :entailment-supported (.isEntailmentCheckingSupported reasoner (.getAxiomType axiom))
                                         :entailed (.isEntailed reasoner axiom)
                                         :contained (.containsAxiomIgnoreAnnotations current-ontology
                                                                          axiom)})
                            (filter (fn [axiom]
                                      (not (some (fn [a] (= (str axiom) a)) (map str (set (.getAxioms current-ontology))))))
                                    (set (.getAxioms new-ontology))))]
             ; (println "$$$$ " (.getReasonerName reasoner))
             ;(.dispose reasoner)
             diffs)))

(defn diff-ontologies [table]
    ; (println "---table" table)
    (let [tmp-file (java.io.File/createTempFile "tmp_ontology" ".owl")
          out (new OutputStreamWriter (new FileOutputStream tmp-file) "UTF8")]
            (.deleteOnExit tmp-file)
            (.write out (get table "ontology"))
            (.close out)
      (let [o-ontology (ontology-from-file (get table "origin_ontology_path"))
            original-ontology (.. OWLOntologyManager (createOntology  (OWLOntologyID. (.. o-ontology (getOntologyID) (getOntologyIRI)) (IRI/create "origin"))))]
          (.. OWLOntologyManager (setOntologyFormat original-ontology (.getOntologyFormat OWLOntologyManager o-ontology)))
          (.addAxioms OWLOntologyManager original-ontology (.getAxioms o-ontology))
          (.removeOntology OWLOntologyManager o-ontology)
          (let [tda-ontology (ontology-from-file (.getAbsolutePath tmp-file))
                diff {:missing (diff tda-ontology original-ontology)
                      :extra (diff original-ontology tda-ontology)}]
                  ; add axioms for whom entailment not supported - they must be checket by hand
            (serialize diff)))))
