(ns
  #^{:author "renarl",
     :doc "tda preferences"}
  lv.lumii.tda.preferences
  (:use lv.lumii.tda))

(defn export-preferences []
  #_(.. PreferencesManager (getInstance) (getPreferencesForSet "lv.lumii.tda" "export-preferences")))

(defn exporter-enabled? [exporter-name]
	(let [value (get @lv.lumii.tda/*preferences* exporter-name true)]
    (if (= value "false")
      false
      value))
  #_(.. (export-preferences) (getBoolean exporter-name true)))

(defn enable-exporter! [exporter-name]
  #_(.. (export-preferences) (putBoolean exporter-name true)))

(defn disable-exporter! [exporter-name]
  #_(.. (export-preferences) (putBoolean exporter-name false)))

(defn- renderer-preferences [exporter-name]
  #_(.. PreferencesManager (getInstance) (getPreferencesForSet "lv.lumii.tda.exporter" exporter-name)))

(defn renderer-for-exporter [exporter-name]
  #_(.. (renderer-preferences exporter-name) (getString "renderer" "default")))

(defn set-renderer-for-exporter! [exporter-name renderer-name]
  #_(.. (renderer-preferences exporter-name) (putString "renderer" renderer-name)))