(ns
  #^{:author "renarl",
     :doc "utilities to send data over network"}
  lv.lumii.tda.send
	(:use clojure.java.io)
  (:import
    (java.io IOException OutputStreamWriter PrintWriter BufferedReader InputStreamReader)
    (java.net Socket InetSocketAddress SocketTimeoutException UnknownHostException)))

(defn host-up? [hostname timeout port]
  (let [sock-addr (new InetSocketAddress hostname port)]
    (try
      (with-open [sock (new Socket)]
        (.connect sock sock-addr timeout)
        sock)
      (catch IOException e false)
      (catch SocketTimeoutException e false)
      (catch UnknownHostException e false))))

; (defn send-data [hostname timeout port data]
;   (let [socket-address (new InetSocketAddress hostname port)
;         socket (Socket.)]
;       (do (println "host " hostname ":" port " is up? - " (host-up? hostname timeout port))
;         (doto socket (.connect socket-address timeout))
;         (println socket)
;         (println "data length = " (.length data))
;         (.println (PrintWriter. (new OutputStreamWriter (.getOutputStream socket) "UTF8") true) data)
;         (.close socket))))

(defn send-data [hostname timeout port data wait-reply]
  (let [socket-address (new InetSocketAddress hostname port)
        socket (Socket.)]
      (do (println "host " hostname ":" port " is up? - " (host-up? hostname timeout port))
        (doto socket (.connect socket-address timeout))
        (println socket)
        (println "data length = " (.length data))
        (.println (PrintWriter. (new OutputStreamWriter (.getOutputStream socket) "UTF8") true) data)
        (if wait-reply
					(let [replay (.replace (slurp (-> (.getInputStream socket)
                                                                        	(InputStreamReader. "UTF8")
                                                                        	BufferedReader.))
                                 "\\\n" "\n")]
            (.close socket)
            replay)
					(.close socket)))))