(ns
    #^{:author "renarl",
       :doc "utilities to serialize as lua tables"}
  lv.lumii.tda.serialize)

(declare to-lua)

(defn- lua-keyword [val]
  (if (or (keyword? val) (symbol? val))
    (pr-str (name val))
    (if (integer? val)
      (str val)
      (to-lua val))))

(defn- to-lua-table [coll]
  (str "{" 
       (reduce (fn ([a b] 
                      (str a ", " b))
                 ([a] (str a))
                 ([] ""))
               (if (map? coll)
                 (map (fn [[key value]]
                        (str "[" (lua-keyword key) "] = " (trampoline to-lua value)))
                      coll)
                 (map (fn [a] (trampoline to-lua a))
                      coll)))
       "}"))

(defn- to-lua [v]
  (cond
    (nil? v) "nil"
    (coll? v) (trampoline to-lua-table v)
    :else (pr-str (.toString v))))

(defn serialize [value]
  (to-lua value))