(ns
  #^{:author "renarl",
     :doc "utility functions"}
  lv.lumii.tda.utilities
  (:use clojure.set))

(defn deep-merge-with
  "Like merge-with, but merges maps recursively, applying the given fn
  only when there's a non-map at a particular level.
 
  (deepmerge + {:a {:b {:c 1 :d {:x 1 :y 2}} :e 3} :f 4}
               {:a {:b {:c 2 :d {:z 9} :z 3} :e 100}})
  -> {:a {:b {:z 3, :c 3, :d {:z 9, :x 1, :y 2}}, :e 103}, :f 4}"
  [f & maps]
  (apply
    (fn m [& maps]
      (if (every? map? maps)
        (apply merge-with m maps)
        (apply f maps)))
    maps))

;(defmulti my-merge (fn [a b] (and (col))))

(defn my-merge [a b]
  (cond 
   (and (map? a) (map? b))
   (reduce (fn [acc key]
             (do (assert key)
                 (assoc-in acc
                           [key]
                           (my-merge (get acc key) (get b key)))))
           a
           (keys b))
   (and (map? a) (coll? b))
   (reduce (fn [acc m]
             (my-merge acc m))
           a b)
   (and (set? a) (set? b)) (union a b)
   (nil? a) b
   (nil? b) a
   (set? a) (conj a b)
   (set? b) (conj b a)
   (= a b) a
   :else (conj #{a} b)))

;(my-merge 1 1)
  ;#{1}
;(my-merge 1 2)
  ;#{1 2}
;(my-merge #{1} 2)
  ;#{1 2}
;(my-merge 1 #{2})
  ;#{1 2}
;(my-merge #{1} 1)
  ;#{1}
;(my-merge {:a 1} {:a 2})
  ;{:a #{1 2}}
;(my-merge {:a 1} {:a 1})
  ;{:a #{1}}
;(my-merge {:a {:b 1}} {:a {:b 2}})
  ;{:a {:b #{1 2}}}
;(my-merge {:a {:b 1}} {:a {:c 2}})
  ;{:a {:c 2, :b 1}}
;(my-merge {:a {:b 1}} #{{:c 3}})
  ;{:c 3, :a {:b 1}}
;(my-merge {:a {:b 1}} #{{:c 3 :a {:d 4 :b 2}}})
  ;{:c 3, :a {:d 4, :b #{1 2}}}
;(my-merge {:a {:b 1}} #{{:c 3} {:a {:d 4 :b 2}}})
  ;{:c 3, :a {:d 4, :b #{1 2}}}



(defn reduce-with-merge
  ([acc list-of-maps]
     (reduce my-merge acc list-of-maps))
  ([list-of-maps]
     (reduce-with-merge {} list-of-maps)))

(defn concat-with [coll separator]
  (reduce 
    (fn 
      ([acc b] (str acc separator b))
      ([a] (str a))
      ([] ""))
    coll))

;(concat-with #{"a" "b" "c"} "-")
  ;"a-b-c"
;(concat-with #{"a" "b"} "-")
  ;"a-b"
;(concat-with #{"a"} "-")
  ;"a"
;(concat-with #{} "-")
  ;""


(defn my-diff [a b]
  (cond
   (and (map? a) (map? b))
   (reduce (fn [acc key]
             (let [current-value (get acc key)
                   r (my-diff current-value (get b key))]
               (if-not (or (nil? r) (and (coll? r) (empty? r)))
                 (assoc-in acc [key] r)
                 (dissoc acc key))))
           a
           (keys b))
   (and (map? a) (coll? b))
   (reduce (fn [acc m]
             (my-diff acc m))
           a b)
   (and (set? a) (set? b)) (difference a b)
   (nil? a) nil
   (nil? b) a
   (= a b) (empty a)
   (coll? a) (disj (set a) b)
   :else a))

(defn dissoc-from [m k]
  (let [current-value (get-in m k)]
    (my-diff m (assoc-in {} k current-value))))


