module(..., package.seeall)

require("lua_tda")
local languageFields = require "OWLCNL_LanguageFields.languageFields"

function completeMetamodel()
		lQuery.model.add_class("OWLCNL#LanguageRowDef")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "makeFieldGroup")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "isUniversal")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "languageName")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "languageCode")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "languageCodeGF")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "rowTitle")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "procInit")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "procLoad")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "procSave")
		lQuery.model.add_property("OWLCNL#LanguageRowDef", "type")
	lQuery.model.add_class("OWLCNL#FieldDef")
		lQuery.model.add_property("OWLCNL#FieldDef", "selectorPath")
		lQuery.model.add_property("OWLCNL#FieldDef", "procValueUpdated")
		lQuery.model.add_property("OWLCNL#FieldDef", "fieldMode")
		lQuery.model.add_property("OWLCNL#FieldDef", "caption")
		lQuery.model.add_property("OWLCNL#FieldDef", "fieldType")
		lQuery.model.add_property("OWLCNL#FieldDef", "suffixValue")
		lQuery.model.add_property("OWLCNL#FieldDef", "isEnabled")
		lQuery.model.add_property("OWLCNL#FieldDef", "domainValue")
		lQuery.model.add_property("OWLCNL#FieldDef", "isAvailable")
		lQuery.model.add_property("OWLCNL#FieldDef", "value")
		lQuery.model.add_property("OWLCNL#FieldDef", "isEditable")
		lQuery.model.add_property("OWLCNL#FieldDef", "suffixFieldID")
	lQuery.model.add_class("OWLCNL#ChoiceItemDef")
		lQuery.model.add_property("OWLCNL#ChoiceItemDef", "domainValue")
		lQuery.model.add_property("OWLCNL#ChoiceItemDef", "formValue")
		lQuery.model.add_property("OWLCNL#ChoiceItemDef", "isDefault")
		lQuery.model.add_property("OWLCNL#ChoiceItemDef", "isAvailable")
	lQuery.model.add_class("OWLCNL#EventHandlerDef")
		lQuery.model.add_property("OWLCNL#EventHandlerDef", "eventName")
		lQuery.model.add_property("OWLCNL#EventHandlerDef", "procName")
		lQuery.model.add_property("OWLCNL#EventHandlerDef", "eventType")
	
	
	lQuery.model.add_class("OWLCNL#LanguageRow")
		lQuery.model.add_property("OWLCNL#LanguageRow", "makeFieldGroup")
		lQuery.model.add_property("OWLCNL#LanguageRow", "isUniversal")
		lQuery.model.add_property("OWLCNL#LanguageRow", "languageName")
		lQuery.model.add_property("OWLCNL#LanguageRow", "languageCode")
		lQuery.model.add_property("OWLCNL#LanguageRow", "languageCodeGF")
		lQuery.model.add_property("OWLCNL#LanguageRow", "rowTitle")
		lQuery.model.add_property("OWLCNL#LanguageRow", "procInit")
		lQuery.model.add_property("OWLCNL#LanguageRow", "procLoad")
		lQuery.model.add_property("OWLCNL#LanguageRow", "procSave")
		lQuery.model.add_property("OWLCNL#LanguageRow", "type")
	lQuery.model.add_class("OWLCNL#Field")
		lQuery.model.add_property("OWLCNL#Field", "selectorPath")
		lQuery.model.add_property("OWLCNL#Field", "procValueUpdated")
		lQuery.model.add_property("OWLCNL#Field", "fieldMode")
		lQuery.model.add_property("OWLCNL#Field", "caption")
		lQuery.model.add_property("OWLCNL#Field", "fieldType")
		lQuery.model.add_property("OWLCNL#Field", "suffixValue")
		lQuery.model.add_property("OWLCNL#Field", "isEnabled")
		lQuery.model.add_property("OWLCNL#Field", "domainValue")
		lQuery.model.add_property("OWLCNL#Field", "isAvailable")
		lQuery.model.add_property("OWLCNL#Field", "value")
		lQuery.model.add_property("OWLCNL#Field", "isEditable")
		lQuery.model.add_property("OWLCNL#Field", "suffixFieldID")
	lQuery.model.add_class("OWLCNL#Item")
		lQuery.model.add_property("OWLCNL#Item", "domainValue")
		lQuery.model.add_property("OWLCNL#Item", "formValue")
		lQuery.model.add_property("OWLCNL#Item", "isDefault")
		lQuery.model.add_property("OWLCNL#Item", "isAvailable")
	
	lQuery.model.add_link("OWLCNL#LanguageRow", "languageRow", "field", "OWLCNL#Field")
	
	lQuery.model.add_composition("OWLCNL#Item","item","field","OWLCNL#Field")
	
	lQuery.model.add_composition("OWLCNL#FieldDef","fieldDef","IPack","OWLCNL#LanguageRowDef")
	lQuery.model.add_composition("OWLCNL#EventHandlerDef","eventHandlerDef","languageRowDef","OWLCNL#LanguageRowDef")
	lQuery.model.add_composition("OWLCNL#ChoiceItemDef","choiceItemDef","fieldDef","OWLCNL#FieldDef")
	
	lQuery.model.add_link("OWLCNL#LanguageRowDef", "languageRowDef", "mainField", "OWLCNL#FieldDef")
	
	
	
	local prEH1  = lQuery.create("PropertyEventHandler", {eventType = "onClose", procedureName = "OWLCNL_LanguageFields.languageFields.functionOnClose"})
	local prEH2  = lQuery.create("PropertyEventHandler", {eventType = "onClose", procedureName = "OWLCNL_LanguageFields.languageFields.functionOnClose"})
	local prEH3  = lQuery.create("PropertyEventHandler", {eventType = "onClose", procedureName = "OWLCNL_LanguageFields.languageFields.functionOnClose"})
	
	lQuery("PropertyDiagram[id='Class']"):link("propertyEventHandler", prEH1)
	lQuery("PropertyDiagram[id='Object']"):link("propertyEventHandler", prEH2)
	lQuery("PropertyDiagram[id='Association']"):link("propertyEventHandler", prEH3)
	
	languageFields.loadLuaTable()
	
	local fieldDefNoun = lQuery("OWLCNL#ChoiceItemDef[formValue='Noun']/fieldDef")
	lQuery("OWLCNL#ChoiceItemDef[formValue='Noun']"):remove_link("fieldDef", fieldDefNoun)
	lQuery("OWLCNL#ChoiceItemDef[formValue='Noun']"):link("fieldDef", fieldDefNoun)
end